/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.Block0Descriptor;
import com.quantumdata.edideditor.CEAAudioDataBlock;
import com.quantumdata.edideditor.CEAColorimetryDataBlock;
import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.CEAGenericVSDBlock;
import com.quantumdata.edideditor.CEAHdmiVendorSpecDataBlock;
import com.quantumdata.edideditor.CEASpeakerAllocDataBlock;
import com.quantumdata.edideditor.CEAVideoCapabilityDataBlock;
import com.quantumdata.edideditor.CEAVideoDataBlock;
import com.quantumdata.edideditor.CVT3ByteCodeDescriptor;
import com.quantumdata.edideditor.ColorManagementData;
import com.quantumdata.edideditor.ColorPointDescriptor;
import com.quantumdata.edideditor.DataBlock;
import com.quantumdata.edideditor.DescriptorType;
import com.quantumdata.edideditor.DummyDescriptor;
import com.quantumdata.edideditor.EstablishedTimingsIIIDescriptor;
import com.quantumdata.edideditor.ExtensionBlock;
import com.quantumdata.edideditor.MonitorASCIIData;
import com.quantumdata.edideditor.MonitorManufacturer;
import com.quantumdata.edideditor.MonitorName;
import com.quantumdata.edideditor.MonitorRangeLimits;
import com.quantumdata.edideditor.MonitorSTI;
import com.quantumdata.edideditor.MonitorSerialNumber;
import com.quantumdata.edideditor.TimingDescriptor;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class CEAExtension
extends ExtensionBlock {
    private int ceaOffset_d;
    private int numberNativeFormats_support;
    private int extensionBlockChecksum;
    private ArrayList<DataBlock> aDataBlocks = new ArrayList();
    private ArrayList<Block0Descriptor> aDescriptors = new ArrayList();
    private static final int maxBlockSize = 127;

    public CEAExtension() {
        super(2, 3);
    }

    public String getChecksum() {
        return String.format("%02X", this.extensionBlockChecksum);
    }

    private void reSort() {
        if (this.aDescriptors.get(0).getDescriptorType() != 0) {
            for (int i = 0; i < this.aDescriptors.size(); ++i) {
                if (this.aDescriptors.get(i).getDescriptorType() != 0) continue;
                this.swap(0, i);
                break;
            }
        }
    }

    private void swap(int n, int n2) {
        Block0Descriptor block0Descriptor = this.aDescriptors.get(n2);
        this.aDescriptors.remove(n2);
        this.aDescriptors.add(n2, this.aDescriptors.get(n));
        this.aDescriptors.set(n, block0Descriptor);
    }

    private void swapDataBlocks(int n, int n2) {
        DataBlock dataBlock = this.aDataBlocks.get(n2);
        this.aDataBlocks.remove(n2);
        this.aDataBlocks.add(n2, this.aDataBlocks.get(n));
        this.aDataBlocks.set(n, dataBlock);
    }

    private boolean enoughSpaceForAnotherDesc() {
        int n = this.aDescriptors.size() * 18;
        int n2 = n + this.ceaOffset_d;
        return n2 <= 109;
    }

    public int getFirstMonitorDescIndex() {
        int n;
        if (!this.enoughSpaceForAnotherDesc()) {
            return -1;
        }
        for (n = 0; n < this.aDescriptors.size(); ++n) {
            if (this.aDescriptors.get(n).getDescriptorType() == 0) continue;
            return n;
        }
        return n;
    }

    public boolean addBlock0Descriptor(Block0Descriptor block0Descriptor) {
        boolean bl;
        if (this.enoughSpaceForAnotherDesc()) {
            bl = this.aDescriptors.add(block0Descriptor);
            this.reSort();
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean addBlock0Descriptor(Block0Descriptor block0Descriptor, int n) {
        if (this.enoughSpaceForAnotherDesc()) {
            this.aDescriptors.add(n, block0Descriptor);
            this.reSort();
            return true;
        }
        return false;
    }

    public int getNumBlock0Descriptors() {
        return this.aDescriptors.size();
    }

    public Block0Descriptor getBlock0Descriptor(int n) {
        if (n < this.aDescriptors.size()) {
            return this.aDescriptors.get(n);
        }
        return null;
    }

    public void clearBlock0Descriptors() {
        this.aDescriptors.clear();
        this.generateChecksum();
    }

    public boolean removeBlock0Descriptor(int n) {
        boolean bl = false;
        if (n >= this.aDescriptors.size() | n < 0) {
            bl = false;
        } else {
            this.aDescriptors.remove(n);
            bl = true;
        }
        this.aDescriptors.trimToSize();
        this.generateChecksum();
        return bl;
    }

    private int getDTDsChecksumValue() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string = new String();
        while (n2 < this.aDescriptors.size()) {
            string = this.aDescriptors.get(n2++).extractDescriptorData();
            for (n3 = 0; n3 < string.length(); n3 += 2) {
                n += Integer.parseInt(string.substring(n3, n3 + 2), 16);
            }
            n &= 0xFF;
        }
        return n & 0xFF;
    }

    public void setUnderscanSupport(int n) {
        this.numberNativeFormats_support &= 0x7F;
        this.numberNativeFormats_support |= n << 7;
    }

    public int getUnderscanSupport() {
        return this.numberNativeFormats_support >> 7;
    }

    public void setBasicAudioSupport(int n) {
        this.numberNativeFormats_support &= 0xBF;
        this.numberNativeFormats_support |= n << 6;
    }

    public int getBasicAudioSupport() {
        return this.numberNativeFormats_support >> 6 & 1;
    }

    public void setYCBCR444Support(int n) {
        this.numberNativeFormats_support &= 0xDF;
        this.numberNativeFormats_support |= n << 5;
    }

    public int getYCBCR444Support() {
        return this.numberNativeFormats_support >> 5 & 1;
    }

    public void setYCBCR422Support(int n) {
        this.numberNativeFormats_support &= 0xEF;
        this.numberNativeFormats_support |= n << 4;
    }

    public int getYCBCR422Support() {
        return this.numberNativeFormats_support >> 4 & 1;
    }

    public void setTotalTimingDescriptors(int n) {
        this.numberNativeFormats_support &= 0xF0;
        this.numberNativeFormats_support |= n;
    }

    public int getTotalTimingDescriptors() {
        return this.numberNativeFormats_support & 0xF;
    }

    public int getByte3() {
        return this.numberNativeFormats_support;
    }

    public void setByte3(int n) {
        this.numberNativeFormats_support = n;
    }

    public int getNumberOfDataBlocks() {
        return this.aDataBlocks.size();
    }

    public String getDataBlockName(int n) {
        if (this.aDataBlocks.size() != 0) {
            return this.aDataBlocks.get(n).getDataBlockName();
        }
        return null;
    }

    public DataBlock getDataBlock(int n) {
        return this.aDataBlocks.get(n);
    }

    public void removeDataBlock(int n) {
        this.aDataBlocks.remove(n);
        this.updateDataBlockCollectionSize();
    }

    public boolean addExtensionDescriptor(CEADescriptor cEADescriptor) {
        String string = "";
        DataBlock dataBlock = null;
        boolean bl = true;
        int n = 123 - this.getSizeOfDataBlockCollection() - this.aDescriptors.size() * 18;
        if (n > 0 && n > cEADescriptor.getDescriptorLength()) {
            if (cEADescriptor.getDescriptorType() == DescriptorType.SHORT_VIDEO_DES) {
                string = DescriptorType.SHORT_VIDEO_DES.getBlockName();
            }
            if (cEADescriptor.getDescriptorType() == DescriptorType.SHORT_AUDIO_DES) {
                string = DescriptorType.SHORT_AUDIO_DES.getBlockName();
            }
            if (cEADescriptor.getDescriptorType() == DescriptorType.SPKR_ALLOC_DES) {
                string = DescriptorType.SPKR_ALLOC_DES.getBlockName();
            }
            if (cEADescriptor.getDescriptorType() == DescriptorType.GENERIC_VSDB_DES) {
                string = DescriptorType.GENERIC_VSDB_DES.getBlockName();
            }
            if (cEADescriptor.getDescriptorType() == DescriptorType.HDMI_VSDB_DES) {
                string = DescriptorType.HDMI_VSDB_DES.getBlockName();
            }
            if (cEADescriptor.getDescriptorType() == DescriptorType.COLORIMETRY_DES) {
                string = DescriptorType.COLORIMETRY_DES.getBlockName();
            }
            if (cEADescriptor.getDescriptorType() == DescriptorType.VIDEO_CAP_DES) {
                string = DescriptorType.VIDEO_CAP_DES.getBlockName();
            }
            for (int i = 0; i < this.aDataBlocks.size(); ++i) {
                if (this.aDataBlocks.get(i).getDataBlockName() != string) continue;
                dataBlock = this.aDataBlocks.get(i);
            }
            if (dataBlock == null) {
                dataBlock = this.addNewDataBlock(cEADescriptor.getDescriptorType());
            }
            if (dataBlock == null) {
                bl = false;
            }
            if (!dataBlock.addDescriptor(cEADescriptor)) {
                if (!dataBlock.isJustOneCopyAllowed()) {
                    dataBlock = this.addNewDataBlock(cEADescriptor.getDescriptorType());
                    if (!dataBlock.addDescriptor(cEADescriptor)) {
                        JOptionPane.showMessageDialog(null, "ERROR: Added another data block but couldn't add descriptor to it!");
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "ERROR: Could not add descriptor to selected data block!");
                }
            }
            this.updateDataBlockCollectionSize();
            this.reArrangeDataBlocks();
        } else {
            JOptionPane.showMessageDialog(null, "ERROR: There's no more space in this extension block");
            bl = false;
        }
        return bl;
    }

    private DataBlock addNewDataBlock(DescriptorType descriptorType) {
        switch (descriptorType.getIndex()) {
            case 0: {
                this.aDataBlocks.add(new CEAVideoDataBlock());
                break;
            }
            case 1: {
                this.aDataBlocks.add(new CEAAudioDataBlock());
                break;
            }
            case 2: {
                this.aDataBlocks.add(new CEASpeakerAllocDataBlock());
                break;
            }
            case 3: {
                this.aDataBlocks.add(new CEAGenericVSDBlock());
                break;
            }
            case 4: {
                this.aDataBlocks.add(new CEAHdmiVendorSpecDataBlock());
                break;
            }
            case 5: {
                this.aDataBlocks.add(new CEAColorimetryDataBlock());
                break;
            }
            case 6: {
                this.aDataBlocks.add(new CEAVideoCapabilityDataBlock());
                break;
            }
        }
        return this.aDataBlocks.get(this.aDataBlocks.size() - 1);
    }

    private void reArrangeDataBlocks() {
        block0: for (int i = 0; i < this.aDataBlocks.size(); ++i) {
            if (this.aDataBlocks.get(i).isJustOneCopyAllowed()) continue;
            if (i + 1 == this.aDataBlocks.size()) {
                return;
            }
            for (int j = i + 1; j < this.aDataBlocks.size(); ++j) {
                if (!this.aDataBlocks.get(j).isJustOneCopyAllowed()) continue;
                this.swapDataBlocks(i, j);
                continue block0;
            }
        }
    }

    private void updateDataBlockCollectionSize() {
        this.ceaOffset_d = 4;
        if (this.aDataBlocks.size() == 0) {
            this.ceaOffset_d = this.aDescriptors.size() == 0 ? 0 : 4;
        } else {
            for (int i = 0; i < this.aDataBlocks.size(); ++i) {
                this.ceaOffset_d += this.aDataBlocks.get(i).getDataBlockLength();
            }
        }
    }

    public int getSizeOfDataBlockCollection() {
        int n = 0;
        for (int i = 0; i < this.getNumberOfDataBlocks(); ++i) {
            n += this.aDataBlocks.get(i).getDataBlockLength();
        }
        return n;
    }

    public String uploadData(String string) {
        int n;
        String string2 = null;
        super.setRevision(Integer.parseInt(string.substring(2, 4), 16));
        this.ceaOffset_d = Integer.parseInt(string.substring(4, 6), 16);
        this.numberNativeFormats_support = n = Integer.parseInt(string.substring(6, 8), 16);
        if (this.ceaOffset_d == 0) {
            return string2;
        }
        if (this.ceaOffset_d != 4) {
            this.parseIntoDataBlocks(string.substring(8, this.ceaOffset_d * 2));
        }
        if ((string2 = this.parseDTDs(string.substring(this.ceaOffset_d * 2, string.length()))) != null) {
            return string2;
        }
        this.extensionBlockChecksum = Integer.parseInt(string.substring(string.length() - 2, string.length()), 16);
        return string2;
    }

    public String extractBlockData() {
        int n;
        this.updateDataBlockCollectionSize();
        String string = new String();
        this.generateChecksum();
        string = string.concat(String.format("%02X", this.iExtensionTag));
        string = string.concat(String.format("%02X", this.iExtensionRevision));
        string = string.concat(String.format("%02X", this.ceaOffset_d));
        int n2 = 0;
        n2 = this.getUnderscanSupport() << 7;
        n2 |= this.getBasicAudioSupport() << 6;
        n2 |= this.getYCBCR444Support() << 5;
        n2 |= this.getYCBCR422Support() << 4;
        string = string.concat(String.format("%02X", n2 |= this.numberNativeFormats_support));
        for (n = 0; n < this.aDataBlocks.size(); ++n) {
            string = string.concat(this.aDataBlocks.get(n).extractDataBlockData());
        }
        for (n = 0; n < this.aDescriptors.size(); ++n) {
            string = string.concat(this.aDescriptors.get(n).extractDescriptorData());
        }
        string = string.concat(this.addPadding());
        string = string.concat(String.format("%02X", this.extensionBlockChecksum));
        return string;
    }

    public int generateChecksum() {
        int n;
        int n2 = 0;
        n2 += this.iExtensionTag;
        n2 += this.iExtensionRevision;
        n2 += this.ceaOffset_d;
        int n3 = 0;
        n3 = this.getUnderscanSupport() << 7;
        n3 |= this.getBasicAudioSupport() << 6;
        n3 |= this.getYCBCR444Support() << 5;
        n3 |= this.getYCBCR422Support() << 4;
        n2 += (n3 |= this.numberNativeFormats_support);
        int n4 = 0;
        for (int i = 0; i < this.aDataBlocks.size(); ++i) {
            n4 += this.aDataBlocks.get(i).getDataBlockChecksum();
        }
        n2 += n4;
        this.extensionBlockChecksum = n = 256 - (n2 += this.getDTDsChecksumValue()) & 0xFF;
        return n;
    }

    private String addPadding() {
        int n = 123 - this.getSizeOfDataBlockCollection() - this.aDescriptors.size() * 18;
        if ((n *= 2) > 0) {
            char[] cArray = new char[n];
            --n;
            while (n >= 0) {
                cArray[n] = 48;
                --n;
            }
            return new String(cArray);
        }
        return "";
    }

    private void parseIntoDataBlocks(String string) {
        int n;
        boolean bl = false;
        DataBlock dataBlock = null;
        for (int i = 0; i < string.length(); i += n) {
            int n2 = Integer.parseInt(string.substring(i, i + 2), 16);
            int n3 = Integer.parseInt(string.substring(i + 2, i + 4), 16);
            int n4 = n2 >> 5;
            int n5 = n2 & 0x1F;
            n = (n5 + 1) * 2;
            bl = false;
            switch (n4) {
                case 0: {
                    n = string.length();
                    bl = true;
                    break;
                }
                case 1: {
                    dataBlock = new CEAAudioDataBlock();
                    break;
                }
                case 2: {
                    dataBlock = new CEAVideoDataBlock();
                    break;
                }
                case 3: {
                    int n6 = Integer.parseInt(string.substring(i + 2, i + 4), 16);
                    int n7 = Integer.parseInt(string.substring(i + 4, i + 6), 16);
                    int n8 = Integer.parseInt(string.substring(i + 6, i + 8), 16);
                    if (n6 == 3 && n7 == 12 && n8 == 0) {
                        dataBlock = new CEAHdmiVendorSpecDataBlock();
                        break;
                    }
                    dataBlock = new CEAGenericVSDBlock();
                    break;
                }
                case 4: {
                    dataBlock = new CEASpeakerAllocDataBlock();
                    break;
                }
                case 7: {
                    if (n3 == 5) {
                        dataBlock = new CEAColorimetryDataBlock();
                        break;
                    }
                    if (n3 != 0) break;
                    dataBlock = new CEAVideoCapabilityDataBlock();
                    break;
                }
                default: {
                    System.out.printf("Did not recognize data block tag: %i\n", n4);
                    bl = true;
                }
            }
            if (!bl) {
                ((DataBlock)dataBlock).uploadDataBlockData(string.substring(i, i + n));
            }
            this.aDataBlocks.add(dataBlock);
        }
        this.reArrangeDataBlocks();
    }

    private String parseDTDs(String string) {
        String string2 = null;
        Block0Descriptor block0Descriptor = null;
        int n = 0;
        n = string.length();
        for (int i = 0; i < n - 18; i += 36) {
            int n2 = Integer.parseInt(string.substring(i, i + 2), 16);
            if (n2 != 0) {
                block0Descriptor = new TimingDescriptor();
            } else {
                n2 = Integer.parseInt(string.substring(i + 6, i + 8), 16);
                String string3 = string.substring(i, string.length() - 2);
                int n3 = 0;
                for (int j = string3.length(); j > 0; j -= 2) {
                    n3 += Integer.parseInt(string3.substring(j - 2, j), 16);
                }
                if (n2 <= 15) {
                    if (i + 36 > string.length()) {
                        return string2;
                    }
                    if (n3 == 0) {
                        return string2;
                    }
                }
                switch (n2) {
                    case 255: {
                        block0Descriptor = new MonitorSerialNumber();
                        break;
                    }
                    case 254: {
                        block0Descriptor = new MonitorASCIIData();
                        break;
                    }
                    case 253: {
                        block0Descriptor = new MonitorRangeLimits();
                        break;
                    }
                    case 252: {
                        block0Descriptor = new MonitorName();
                        break;
                    }
                    case 251: {
                        if (this.iExtensionRevision == 3) {
                            string2 = "We do not support color point descriptors.";
                            return string2;
                        }
                        if (this.iExtensionRevision != 4) break;
                        block0Descriptor = new ColorPointDescriptor();
                        break;
                    }
                    case 250: {
                        block0Descriptor = new MonitorSTI();
                        break;
                    }
                    case 249: {
                        if (this.iExtensionRevision == 4) {
                            block0Descriptor = new ColorManagementData();
                            break;
                        }
                    }
                    case 248: {
                        if (this.iExtensionRevision == 4) {
                            block0Descriptor = new CVT3ByteCodeDescriptor();
                            break;
                        }
                    }
                    case 247: {
                        if (this.iExtensionRevision == 4) {
                            block0Descriptor = new EstablishedTimingsIIIDescriptor();
                            break;
                        }
                    }
                    case 16: {
                        block0Descriptor = new DummyDescriptor();
                        break;
                    }
                    default: {
                        block0Descriptor = new MonitorManufacturer(n2);
                    }
                }
            }
            if (block0Descriptor instanceof MonitorSTI) {
                ((MonitorSTI)block0Descriptor).uploadDescriptorData(string.substring(i + 10, i + 36));
            } else {
                ((Block0Descriptor)block0Descriptor).uploadDescriptorData(string.substring(i, i + 36));
            }
            if (this.addBlock0Descriptor(block0Descriptor)) continue;
            string2 = "ERROR: Could not add block0 descriptor to extension block";
            return string2;
        }
        return string2;
    }
}

